# Integral Microservice Architecture

This repo contains a minimal runnable microservice architecture for the Integral "self-pay network" prototype:
- Apollo GraphQL server
- Detection FastAPI service
- Verification worker (Node)
- Billing worker (Node)
- React Dashboard
- Postgres + Redis

## Quickstart

1. Build & start everything:
   ```
   docker compose up --build -d
   ```

2. Load DB migrations:
   ```
   docker exec -i $(docker ps -q -f ancestor=postgres:15) psql -U integral -d integral -f postgres/migrations/01_schema.sql
   ```

3. Open:
- Apollo GraphQL: http://localhost:4000/
- Dashboard: http://localhost:3000/
- Detection endpoint: POST http://localhost:3001/detect

## Test
Use the detection POST to create a fault and watch workers process it.

