const { RedisPubSub } = require('graphql-redis-subscriptions');
const Redis = require('ioredis');
require('dotenv').config();
const options = { retryStrategy: times => Math.min(times * 50, 2000) };
const pubsub = new RedisPubSub({
  publisher: new Redis(process.env.REDIS_URL, options),
  subscriber: new Redis(process.env.REDIS_URL, options),
});
module.exports = pubsub;
