const { gql } = require('apollo-server');
const typeDefs = gql`
scalar DateTime
scalar JSON

enum Namespace { infrastructure satellite }

type Location { lat: Float lon: Float }
type Provenance { source: String! license: String retrieved_at: DateTime! }

type InfrastructureFault {
  id: ID!
  namespace: Namespace!
  type: String!
  timestamp: DateTime!
  location: JSON
  severity: Int!
  confirmed: Boolean!
  images: [String]
  provenance: Provenance
}

type Payout {
  id: ID!
  faultId: ID!
  amountMinorUnits: Int!
  currency: String!
  payeeId: String!
  status: String!
  createdAt: DateTime!
  settledAt: DateTime
  txRef: String
}

input IngestFaultInput {
  namespace: Namespace!
  type: String!
  timestamp: DateTime!
  location: JSON
  severity: Int!
  images: [String]
  provenance: JSON
}

input CreatePayoutInput {
  faultId: ID!
  amountMinorUnits: Int!
  currency: String!
  payeeId: String!
}

type Query {
  listInfraFaults(limit: Int = 50, offset: Int = 0): [InfrastructureFault!]
  payoutsForFault(faultId: ID!): [Payout!]
}

type Mutation {
  ingestFault(input: IngestFaultInput!): InfrastructureFault!
  confirmFault(id: ID!, confirmed: Boolean!): InfrastructureFault!
  createPayout(input: CreatePayoutInput!): Payout!
  settlePayout(payoutId: ID!): Payout!
}

type Subscription {
  faultCreated: InfrastructureFault!
  faultConfirmed: InfrastructureFault!
  payoutUpdated: Payout!
}
`;
module.exports = typeDefs;
