require('dotenv').config();
const Redis = require('ioredis');
const { Pool } = require('pg');

const redis = new Redis(process.env.REDIS_URL);
const pool = new Pool({ connectionString: process.env.DATABASE_URL });

redis.subscribe('payouts:created', () => console.log('listening payouts:created'));

redis.on('message', async (ch, msg) => {
  if (ch !== 'payouts:created') return;
  const { payoutId } = JSON.parse(msg);
  try {
    const client = await pool.connect();
    await client.query('BEGIN');
    const r = await client.query('SELECT * FROM payouts WHERE id=$1 FOR UPDATE', [payoutId]);
    if (r.rowCount === 0) { await client.query('ROLLBACK'); client.release(); return; }
    const p = r.rows[0];
    if (p.status !== 'created') { await client.query('ROLLBACK'); client.release(); return; }
    await client.query('UPDATE payouts SET status=$1 WHERE id=$2', ['processing', payoutId]);
    const tx = `TX-${Date.now()}-${Math.floor(Math.random()*1000)}`;
    await client.query('UPDATE payouts SET status=$1, tx_ref=$2, settled_at=now() WHERE id=$3', ['settled', tx, payoutId]);
    await client.query('COMMIT');
    client.release();
    redis.publish('payouts:settled', JSON.stringify({ payoutId, txRef: tx }));
  } catch (e) {
    console.error('settle error', e);
  }
});
