import React from 'react';
import { useFaults } from '../hooks/useFaults';

export default function InfraPanel(){
  const { data, loading } = useFaults();
  if(loading) return <div>Loading...</div>;
  const list = data?.listInfraFaults || [];
  return (
    <div>
      <h2>Recent Faults</h2>
      {list.map(f => (
        <div key={f.id} style={{border:'1px solid #ddd', padding:10, marginBottom:8}}>
          <div><strong>{f.type}</strong> severity {f.severity}</div>
          <div>Confirmed: {String(f.confirmed)}</div>
        </div>
      ))}
    </div>
  );
}
