import React from 'react';
import { MapContainer, TileLayer, Marker, Popup } from 'react-leaflet';
import 'leaflet/dist/leaflet.css';
import L from 'leaflet';
import { useFaults } from '../hooks/useFaults';
delete L.Icon.Default.prototype._getIconUrl;
L.Icon.Default.mergeOptions({
  iconRetinaUrl: require('leaflet/dist/images/marker-icon-2x.png'),
  iconUrl: require('leaflet/dist/images/marker-icon.png'),
  shadowUrl: require('leaflet/dist/images/marker-shadow.png')
});

export default function MapView(){
  const { data } = useFaults();
  const center = [-29.12,26.22];
  return (
    <MapContainer center={center} zoom={13} style={{height:'80vh', width:'100%'}}>
      <TileLayer attribution='&copy; OpenStreetMap contributors' url='https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png' />
      {data?.listInfraFaults?.map(f => {
        const loc = f.location || { lat:-29.12, lon:26.22 };
        return (
          <Marker key={f.id} position={[loc.lat || -29.12, loc.lon || 26.22]}>
            <Popup>
              <div>
                <strong>{f.type}</strong>
                <p>Severity: {f.severity}</p>
                <p>Confirmed: {String(f.confirmed)}</p>
              </div>
            </Popup>
          </Marker>
        );
      })}
    </MapContainer>
  );
}
