import { gql, useQuery, useSubscription } from '@apollo/client';
const LIST_FAULTS = gql`query ListInfraFaults($limit:Int,$offset:Int){ listInfraFaults(limit:$limit,offset:$offset){ id namespace type timestamp severity confirmed images location } }`;
const FAULT_CREATED = gql`subscription { faultCreated { id namespace type timestamp severity confirmed images location } }`;
const FAULT_CONFIRMED = gql`subscription { faultConfirmed { id confirmed } }`;

export function useFaults(){
  const { data, loading, error } = useQuery(LIST_FAULTS, { variables: { limit: 50, offset: 0 }});
  useSubscription(FAULT_CREATED, {
    onSubscriptionData: ({ client, subscriptionData }) => {
      client.refetchQueries({ include: [LIST_FAULTS] });
    }
  });
  useSubscription(FAULT_CONFIRMED, {
    onSubscriptionData: ({ client, subscriptionData }) => {
      client.refetchQueries({ include: [LIST_FAULTS] });
    }
  });
  return { data, loading, error };
}
